using System;
using System.Data;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>2/6/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>This control is used to trap a keystoke in a textbox.  This is used for a datagrid.</summary>

		#endregion

	public class DataGridKeyTrapTextBoxColumn : DataGridTextBoxColumn
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private bool _processAcross = true;

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/6/2003</CreationDate>
		/// <summary>
		///  Data grid key trap text box constructor.
		/// </summary>
		public DataGridKeyTrapTextBoxColumn() : base()
		{
			// Required for Windows.Forms Class Composition Designer support
			InitializeComponent();
			//
			this.TextBox.BorderStyle = BorderStyle.None;
			this.TextBox.TextAlign = HorizontalAlignment.Center;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/6/2003</CreationDate>
		/// <summary>
		/// Gets or sets whether the grid will be processed from left to right.  If this value is false
		/// the grid will be processed from top to bottom.
		/// </summary>
		public bool ProcessAcross
		{
			get
			{
				return _processAcross;
			}
			set 
			{
				_processAcross = value;
				//_keyTrapTextBox.ProcessAcross = value;
			}
		}

		#endregion 

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/11/2003</CreationDate>
		///
		/// <summary>
		/// This event is used to update the indicator column of the datagrid.
		/// Implements BR_2.38
		/// </summary>
		/// <param name="g"></param>
		/// <param name="_Bounds"></param>
		/// <param name="_Source"></param>
		/// <param name="_RowNum"></param>
		/// <param name="_BackBrush"></param>
		/// <param name="_ForeBrush"></param>
		/// <param name="_AlignToRight"></param>
		protected override void Paint(Graphics g, Rectangle _Bounds, CurrencyManager _Source,
			int _RowNum, Brush _BackBrush, Brush _ForeBrush, bool _AlignToRight) 
		{
			try
			{  
				DataGrid grid = this.DataGridTableStyle.DataGrid;
				//
				//BR_2.38
				if(_Bounds.X == 2) 
				{
					string rowStatus = grid[_RowNum, 0].ToString();
					//
					if (rowStatus == "V" || rowStatus == "S")
						_BackBrush = Brushes.Lime;
					else if (rowStatus == "W")
						_BackBrush = Brushes.Yellow;
					else  if (rowStatus == "E" || rowStatus == "U")
						_BackBrush = Brushes.Red;
				}
				//
				DataRow dr = new DataTable().NewRow();
				if (grid.DataSource.GetType() == typeof(System.Data.DataView))
				{
					dr = ((DataView)grid.DataSource).Table.Rows[_RowNum];
				}
				else if (grid.DataSource.GetType() == typeof(System.Data.DataTable))
				{
					dr = ((DataTable)grid.DataSource).Rows[_RowNum];
				}

				if (this.GetColumnValueAtRow(_Source,_RowNum)==DBNull.Value)
				{
					_BackBrush = Brushes.LightGray;
					_ForeBrush = Brushes.LightGray;
					//this.KeyTrapTextBox.ReadOnly = true;
					//
					//this.TextBox.ForeColor = Color.LightGray;
					//this.TextBox.BackColor = Color.LightGray;
					//this.TextBox.ReadOnly = true;
				}
				else if (dr.Table.Columns.Contains(TABLE.ReactivityPhase.ReactivityPhaseCode))
				{
					Common.ReactivityPhase reactivityPhase = (Common.ReactivityPhase)Convert.ToInt32(dr[TABLE.ReactivityPhase.ReactivityPhaseCode].ToString());
					//
					switch (reactivityPhase)
					{
						case (Common.ReactivityPhase.IS):
							if ((this.HeaderText.Trim() == ARTIFICIAL.RT)||(this.HeaderText.Trim() == ARTIFICIAL.C37)
								||(this.HeaderText.Trim() == ARTIFICIAL.AHG)||(this.HeaderText.Trim() == ARTIFICIAL.CC))
							{
								_BackBrush = Brushes.LightGray;
								_ForeBrush = Brushes.LightGray;
								//this.KeyTrapTextBox.ReadOnly = true;
								//
								this.TextBox.ForeColor = Color.LightGray;
								this.TextBox.BackColor = Color.LightGray;
								this.TextBox.ReadOnly = true;
							}
							else
							{
								this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
								this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
								this.TextBox.ReadOnly = false;
							}
							break;
						case (Common.ReactivityPhase.ISandRT):
							if ((this.HeaderText.Trim() == ARTIFICIAL.C37)
								||(this.HeaderText.Trim() == ARTIFICIAL.AHG)||(this.HeaderText.Trim() == ARTIFICIAL.CC))
							{
								_BackBrush = Brushes.LightGray;
								_ForeBrush = Brushes.LightGray;
								//this.KeyTrapTextBox.ReadOnly = true;
								//
								this.TextBox.ForeColor = Color.LightGray;
								this.TextBox.BackColor = Color.LightGray;
								this.TextBox.ReadOnly = true;
							}
							else
							{
								this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
								this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
								this.TextBox.ReadOnly = false;
							}
							break;
						case (Common.ReactivityPhase.ISand37):
							if ((this.HeaderText.Trim() == ARTIFICIAL.RT)
								||(this.HeaderText.Trim() == ARTIFICIAL.AHG)||(this.HeaderText.Trim() == ARTIFICIAL.CC))
							{
								_BackBrush = Brushes.LightGray;
								_ForeBrush = Brushes.LightGray;
								//this.KeyTrapTextBox.ReadOnly = true;
								//
								this.TextBox.ForeColor = Color.LightGray;
								this.TextBox.BackColor = Color.LightGray;
								this.TextBox.ReadOnly = true;
							}
							else
							{
								this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
								this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
								this.TextBox.ReadOnly = false;
							}
							break;
						case (Common.ReactivityPhase.AHGandCC):
							if ((this.HeaderText.Trim() == ARTIFICIAL.IS)
								||(this.HeaderText.Trim() == ARTIFICIAL.RT)||(this.HeaderText.Trim() == ARTIFICIAL.C37))
							{
								_BackBrush = Brushes.LightGray;
								_ForeBrush = Brushes.LightGray;
								//this.KeyTrapTextBox.ReadOnly = true;
								//
								this.TextBox.ForeColor = Color.LightGray;
								this.TextBox.BackColor = Color.LightGray;
								this.TextBox.ReadOnly = true;
							}
							else
							{
								this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
								this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
								this.TextBox.ReadOnly = false;
							}
							break;
						case (Common.ReactivityPhase.ThreeSevenandAHG):
							if ((this.HeaderText.Trim() == ARTIFICIAL.IS)
								||(this.HeaderText.Trim() == ARTIFICIAL.RT))
							{
								_BackBrush = Brushes.LightGray;
								_ForeBrush = Brushes.LightGray;
								//this.KeyTrapTextBox.ReadOnly = true;
								//
								this.TextBox.ForeColor = Color.LightGray;
								this.TextBox.BackColor = Color.LightGray;
								this.TextBox.ReadOnly = true;
							}
							else
							{
								this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
								this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
								this.TextBox.ReadOnly = false;
							}
							break;
						default:
							this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
							this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
							this.TextBox.ReadOnly = false;
							break;
					}
				}
				else
				{
					this.TextBox.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
					this.TextBox.BackColor = Color.FromKnownColor(KnownColor.Window);
					this.TextBox.ReadOnly = false;
				}
				//
			}
			catch(Exception)
			{ /* empty catch */ }
			finally
			{
				base.Paint(g, _Bounds, _Source, _RowNum, _BackBrush, _ForeBrush, _AlignToRight);
			}
		}

//		/// <summary>
//		/// Text box key press event handler.
//		/// </summary>
//		/// <param name="sender">object</param>
//		/// <param name="e">KeyPressEventArgs</param>
//		public virtual void OnTextBoxKeyPress(object sender, KeyPressEventArgs e)
//		{
//			//_isEditing = true; 
//
//			if (TextBoxKeyPress !=null ) 
//			{
//				TextBoxKeyPress(sender, e);
//			}
//		}
//
//		/// <summary>
//		/// Text box key down event handler.
//		/// </summary>
//		/// <param name="sender">object</param>
//		/// <param name="e">KeyPressEventArgs</param>
//		protected virtual void OnTextBoxKeyDown(object sender, KeyEventArgs e)
//		{
//			if (e.KeyCode == Keys.Delete)
//			{
//				_isEditing = true; 
//			}
//		}
//		
//		/// <summary>
//		/// Text box key up event handler.
//		/// </summary>
//		/// <param name="sender">object</param>
//		/// <param name="e">KeyPressEventArgs</param>
//		protected virtual void OnTextBoxKeyUp(object sender, KeyEventArgs e)
//		{
//			if (e.KeyCode == Keys.Delete)
//			{
//				_isEditing = true; 
//			}
//		}
//		
//		/// <summary>
//		/// Text box leave event handler.  Sets the datagrid column value to the value in the textbox and hides the textbox.
//		/// </summary>
//		/// <param name="sender">object</param>
//		/// <param name="e">KeyPressEventArgs</param>
//		private void LeaveKeyTrapTextBox(object sender, EventArgs e)
//		{
//			if(_isEditing)
//			{
//				SetColumnValueAtRow(_source, _rowNum, _keyTrapTextBox.Text);
//				_isEditing = false;
//				Invalidate();
//			}
//			_keyTrapTextBox.Hide();
//		}
//
//
//		/// <summary>
//		/// Overrides the edit event so the key trap text box allows data entry.
//		/// </summary>
//		/// <param name="source">CurrencyManager</param>
//		/// <param name="rowNum">int</param>
//		/// <param name="bounds">Rectangle</param>
//		/// <param name="readOnly">bool</param>
//		/// <param name="instantText">string</param>
//		/// <param name="cellIsVisible">bool</param>
//		protected override void Edit(System.Windows.Forms.CurrencyManager source, int rowNum, System.Drawing.Rectangle bounds, bool readOnlyIndicator, string instantText, bool cellIsVisible)
//		{
//			
//			base.Edit(source, rowNum, bounds, readOnlyIndicator, instantText, cellIsVisible);
//
//			_rowNum = rowNum;
//			_source = source;
//
//			_keyTrapTextBox.Parent = this.TextBox.Parent;
//			_keyTrapTextBox.Location = this.TextBox.Location;
//			_keyTrapTextBox.Size = this.TextBox.Size;
//			_keyTrapTextBox.Text =  this.TextBox.Text;
//			this.TextBox.Visible = false;
//			_keyTrapTextBox.Visible = true;
//			_keyTrapTextBox.BringToFront();
//			_keyTrapTextBox.Focus();
//			
//		}
//
//		/// <summary>
//		///  Overrides commit event handler.  Sets the datagrid column value to the value in the textbox.
//		/// </summary>
//		/// <param name="dataSource">CurrencyManager</param>
//		/// <param name="rowNum">int</param>
//		/// <returns>bool</returns>
//		protected override bool Commit(System.Windows.Forms.CurrencyManager dataSource, int rowNum)
//		{
//			if(_isEditing)
//			{
//				_isEditing = false;
//				SetColumnValueAtRow(dataSource, rowNum, _keyTrapTextBox.Text);
//			}
//			return true;
//		}
	}
}



